% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_raster.R
\name{get_elev_raster}
\alias{get_elev_raster}
\title{Get Raster Elevation}
\usage{
get_elev_raster(locations, z, prj = NULL, src = c("mapzen", "aws"),
  api_key = get_api_key(src), expand = NULL, ...)
}
\arguments{
\item{locations}{Either a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, or \code{raster} object as input.}

\item{z}{The zoom level to return.  The zoom ranges from 1 to 14.  Resolution
of the resultant raster is determined by the zoom and latitude.  For 
details on zoom and resolution see the documentation from Mapzen at 
\url{https://mapzen.com/documentation/terrain-tiles/data-sources/#what-is-the-ground-resolution}}

\item{prj}{A PROJ.4 string defining the projection of the locations argument. 
If a \code{sp} or \code{raster} object is provided, the PROJ.4 
string will be taken from that.  This argument is required for a 
\code{data.frame} of locations."}

\item{src}{A character indicating which API to use, currently either 
"mapzen" (default), or "aws" is used. Both use the same source
tiles.  The Amazon Web Services tiles are best if rate limits
are causing failure of the Mapzen tiles or if you are accessing
the data via and AWS instance.}

\item{api_key}{A valid API key.}

\item{expand}{A numeric value of a distance, in map units, used to expand the
bounding box that is used to fetch the terrain tiles. This can 
be used for features that fall close to the edge of a tile and 
additional area around the feature is desired. Default is NULL.}

\item{...}{Extra arguments to pass to \code{httr::GET} via a named vector, 
\code{config}.   See \code{\link{get_mapzen_terrain}} and 
\code{\link{get_aws_terrain}} for more details.}
}
\value{
Function returns a \code{SpatialPointsDataFrame} in the projection 
        specified by the \code{prj} argument.
}
\description{
Several web services provide access to raster elevation. Currently, this 
function provides access to the Mapzen Terrain Service The function 
accepts a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, or \code{raster} object as input.  A \code{raster} object is 
returned.
}
\details{
Currently, the \code{get_elev_raster} utilizes two separate APIs, 
         the Mapzen Terrain Tile Service 
         (\url{https://mapzen.com/documentation/terrain-tiles/}) or the 
         Amazon Web Services 
         (\url{https://aws.amazon.com/public-datasets/terrain/}).  Both 
         services utilize the same underlying data and provide global 
         coverage, but they have different use cases.  The Mapzen service is
         cached and thus should provide speedier downloads.  It will work 
         without an API key but an API key is suggested. 
         
         Both services are provided via x, y, and z tiles (see 
         \url{http://wiki.openstreetmap.org/wiki/Slippy_map_tilenames} for 
         details.) The x and y are determined from the bounding box of the 
         object submitted for \code{locations} argument, and the z argument 
         must be specified by the user.
}
\examples{
\dontrun{
loc_df <- data.frame(x = runif(6,min=sp::bbox(lake)[1,1], 
                               max=sp::bbox(lake)[1,2]),
                     y = runif(6,min=sp::bbox(lake)[2,1], 
                               max=sp::bbox(lake)[2,2]))
x <- get_elev_raster(locations = loc_df, prj = sp::proj4string(lake), z=10, 
                     api_key = NULL)

data(lake)
x <- get_elev_raster(lake, z = 3, src = "mapzen")
x <- get_elev_raster(lake, z = 12, src = "aws")
}

}

