% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{checks}
\alias{checks}
\alias{check_df}
\alias{check_sclvals}
\alias{compare_sclvals}
\alias{check_mrit}
\alias{check_ovlp}
\alias{check_msdf}
\alias{check_neg}
\alias{check_comp}
\title{Miscellaneous input validation}
\usage{
check_df(x)

check_sclvals(x)

compare_sclvals(x, x_attr)

check_mrit(x)

check_ovlp(x)

check_msdf(x)

check_neg(x)

check_comp(x, mrit_min, use)
}
\arguments{
\item{x}{some arbitrary input to be checked.}

\item{x_attr}{a numeric vector of length 2 indicating the start- and endpoint
of a scale.}

\item{mrit_min}{a numeric constant of length 1 to specify the marginal
corrected item-total correlation.}

\item{use}{an optional string to specify how missing values enter the
analysis. See \code{use} in \code{\link[stats]{cor}} for details.}
}
\value{
All functions are called for their side effects. If there are no
  errors or warnings, no value is returned.
}
\description{
A set of test functions to ensure valid input and give helpful
  advice if it is not.

\code{check_df()} guarantees that \code{x} is an appropriate
  data frame for the analysis. That means: It verifies that \code{x} has less
  than two variables (a single item can't build a core), \code{x} has column
  names (used to pre-build \code{scls} in the overlapping process), if the
  column names are unique, and not of type \code{NA}. It throws an error if
  any of these requirements are not met. Additionally, it warns the user if
  the provided \code{colnames} are not unique or \code{NA}.

\code{check_sclvals()} tests whether \code{x} is a two element
  vector and throws an error if not. Integers are coerced to be of type
  \code{double}. Additionally, the function ensures that the first value is
  smaller than the second. Remember that checking for a two element vector
  implicitly secures that \code{x} is not \code{NULL} (because \code{NULL} is
  a logical constant of length `0`).

\code{compare_sclvals()} makes sure that the \code{sclvals} set
  with \code{overlap()} are equal to those set with \code{disjoint()}. It
  throws an error if not.

\code{check_mrit()} guarantees that the input is a double vector
  of length one. Moreover, the function secures that the lower bound is
  unique and ranges between `0` and `1` (it throws an error if not). In
  addition, it warns a user pre-determining a fragment.

\code{check_ovlp()} safeguards that \code{x} is a character
  vector of length `1`. That means, it throws an error if not. Note that
  \code{switch()} within \code{disjoint()} and \code{overlap()} takes care
  of the input string itself. It throws an error when the given character
  doesn't match any available option.

\code{check_msdf()} guards against inputs that are not of type
  `msdf`. It throws an error if not.

\code{check_neg()} verifies that the input is a logical constant of length 1
and not a missing value (this is necessary because objects of type \code{NA}
are logical constants of length 1, too).

\code{check_comp()} examines the correlation matrix,
  \code{cor(df)}. It complains (throws an error) if no correlation in
  \code{cor(df)} is greater than the specified \code{mrit_min}.
}
\details{
All functions are internal functions.
}
