% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-bedrock.R
\name{chat_bedrock}
\alias{chat_bedrock}
\title{Chat with an AWS bedrock model}
\usage{
chat_bedrock(
  system_prompt = NULL,
  turns = NULL,
  model = NULL,
  profile = NULL,
  echo = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{profile}{AWS profile to use.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://aws.amazon.com/bedrock/}{AWS Bedrock} provides a number of chat
based models, including those Anthropic's
\href{https://aws.amazon.com/bedrock/claude/}{Claude}.

Authenthication is handled through \{paws.common\}, so if authenthication
does not work for you automatically, you'll need to follow the advice
at \url{https://www.paws-r-sdk.com/#credentials}. In particular, if your
org uses AWS SSO, you'll need to run \verb{aws sso login} at the terminal.
}
\examples{
\dontrun{
chat <- chat_bedrock()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_claude}()},
\code{\link{chat_cortex}()},
\code{\link{chat_databricks}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
