% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate}
\alias{interpolate}
\alias{interpolate_file}
\title{Helpers for interpolating data into prompts}
\usage{
interpolate(prompt, ..., .envir = parent.frame())

interpolate_file(path, ..., .envir = parent.frame())
}
\arguments{
\item{prompt}{A prompt string. You should not generally expose this
to the end user, since glue interpolation makes it easy to run arbitrary
code.}

\item{...}{Define additional temporary variables for substitution.}

\item{.envir}{Environment to evaluate \code{...} expressions in. Used when
wrapping in another function. See \code{vignette("wrappers", package = "glue")}
for more details.}

\item{path}{A path to a prompt file (often a \code{.md}).}
}
\value{
A \{glue\} string.
}
\description{
These functions are lightweight wrappers around
\href{https://glue.tidyverse.org/}{glue} that make it easier to interpolate
dynamic data into a static prompt. Compared to glue, these functions
expect you to wrap dynamic values in \code{{{ }}}, making it easier to include
R code and JSON in your prompt.
}
\examples{
joke <- "You're a cool dude who loves to make jokes. Tell me a joke about {{topic}}."

# You can supply valuese directly:
interpolate(joke, topic = "bananas")

# Or allow interpolate to find them in the current environment:
topic <- "applies"
interpolate(joke)
}
