% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.multiteam.R
\name{elo.run.multiteam}
\alias{elo.run.multiteam}
\title{Calculate running Elos for a series of multi-team matches.}
\usage{
elo.run.multiteam(
  formula,
  data,
  na.action,
  subset,
  k = NULL,
  initial.elos = NULL,
  ...
)
}
\arguments{
\item{formula}{A one-sided formula with a \code{\link{multiteam}()} object.
See also the \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{initial.elos}{An optional named vector containing initial Elo ratings for all teams in \code{formula}.
If a single (unnamed) value is supplied, that value is applied to all teams. \code{NULL} (the default)
sets all Elos to 1500.}

\item{...}{Other arguments (not used at this time).}
}
\description{
Calculate running Elos for a series of multi-team matches.
}
\details{
This is like \code{\link{elo.run}} (and in fact it runs \code{\link{elo.run}} in the background).
  The formula takes a \code{\link{multiteam}()} object, which assumes that teams "win"
  in a well-ordered ranking. It assumes that the first place team beats all other teams,
  that the second place team loses to the first but beats the others, etc. In that regard,
  \code{elo.run.multiteam} reduces to \code{elo.run} when the number of teams (\code{ncol(multiteam())}) is 2

However, this is less flexible than \code{elo.run}, because (1) there cannot be ties; (2) it does not accept
adjustments; and (3) k is constant within a "game"
}
\examples{
data(tournament.multiteam)
elo.run.multiteam(~ multiteam(Place_1, Place_2, Place_3, Place_4),
                  data = tournament.multiteam, subset = -28, k = 20)
}
