% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-mail.R
\name{addresses}
\alias{addresses}
\alias{to}
\alias{cc}
\alias{bcc}
\alias{from}
\alias{reply}
\alias{return_path}
\alias{sender}
\title{Add address fields to message}
\usage{
to(msg, ..., append = TRUE, split = ", *")

cc(msg, ..., append = TRUE, split = ", *")

bcc(msg, ..., append = TRUE, split = ", *")

from(msg, addr = NULL, split = ", *")

reply(msg, addr = NULL, split = ", *")

return_path(msg, addr = NULL, split = ", *")

sender(msg, addr = NULL, split = ", *")
}
\arguments{
\item{msg}{A message object.}

\item{...}{Addresses.}

\item{append}{Whether to append or replace addresses.}

\item{split}{Pattern for splitting multiple addresses.}

\item{addr}{Single address.}
}
\value{
A message object.
}
\description{
Add address fields to message
}
\examples{
# Populating the To field.
msg <- envelope()
msg \%>\% to("bob@gmail.com, alice@yahoo.com")
msg \%>\% to("bob@gmail.com", "alice@yahoo.com")
msg \%>\% to(c("bob@gmail.com", "alice@yahoo.com"))

# Populating the Cc field.
msg <- envelope()
msg \%>\% cc("bob@gmail.com, alice@yahoo.com")
msg \%>\% cc("bob@gmail.com", "alice@yahoo.com")
msg \%>\% cc(c("bob@gmail.com", "alice@yahoo.com"))

# Populating the Bcc field.
msg <- envelope()
msg \%>\% bcc("bob@gmail.com, alice@yahoo.com")
msg \%>\% bcc("bob@gmail.com", "alice@yahoo.com")
msg \%>\% bcc(c("bob@gmail.com", "alice@yahoo.com"))

msg <- envelope()

# Populating the From field.
msg \%>\% from("craig@gmail.com")

# Populating the Reply-To field.
msg <- envelope()
msg \%>\% reply("gerry@gmail.com")

# Populating the Return-Path field.
msg <- envelope()
msg \%>\% return_path("bounced-mail@devnull.org")

# Populating the Sender field.
msg <- envelope()
msg \%>\% sender("on_behalf_of@gmail.com")
}
