% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{calculate_models_synergies_tn}
\alias{calculate_models_synergies_tn}
\title{Count the non-synergies of the non-synergistic drug combinations per model (TN)}
\usage{
calculate_models_synergies_tn(unobserved.model.predictions)
}
\arguments{
\item{unobserved.model.predictions}{\code{data.frame} object with rows the models
and columns the drug combinations that were found/observed as \strong{non-synergistic}
(\emph{negative results}). Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}
}
\value{
an integer vector with elements the number of true negative predictions
per model. The model names are given in the \emph{names} attribute (same order
as in the \emph{rownames} attribute of the unobserved.model.predictions
\code{data.frame}).
}
\description{
Since the given \code{unobserved.model.predictions} data.frame has only the
negative results, this function returns the total number of 0's \emph{and}
NA's in each row.
}
\seealso{
Other confusion matrix calculation functions: \code{\link{calculate_mcc}},
  \code{\link{calculate_models_mcc}},
  \code{\link{calculate_models_synergies_fn}},
  \code{\link{calculate_models_synergies_fp}},
  \code{\link{calculate_models_synergies_tp}}
}
\concept{confusion matrix calculation functions}
