% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_mat_based_on_mcc_clustering}
\alias{get_avg_activity_diff_mat_based_on_mcc_clustering}
\title{Get average activity difference matrix based on MCC clustering}
\usage{
get_avg_activity_diff_mat_based_on_mcc_clustering(models.mcc,
  models.stable.state, num.of.mcc.classes, include.NaN.mcc.class)
}
\arguments{
\item{models.mcc}{a numeric vector of Matthews Correlation Coefficient (MCC)
scores, one for each model. The \emph{names} attribute holds the models' names.
Can be the result of using the function \code{\link{calculate_models_mcc}}.}

\item{models.stable.state}{a matrix (nxm) with n models and m nodes. The row
names of the matrix specify the models' names (same order as in the \code{models.mcc}
parameter) whereas the column names specify the name of the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
are either \emph{0} (inactive node) or \emph{1} (active node).}

\item{num.of.mcc.classes}{numeric. A positive integer larger than 2 that
signifies the number of mcc classes (groups) that we should split the models
MCC values (excluding the 'NaN' values).}

\item{include.NaN.mcc.class}{logical. Should the models that have NaN MCC value
(e.g. TP+FP = 0, models that predicted no synergies at all) be classified together
in one class - the 'NaN MCC Class' - and compared with the other model classes
in the analysis? If \emph{TRUE}, then the number of total MCC classes will be
\emph{num.of.mcc.classes + 1}.}
}
\value{
a matrix whose rows are \strong{vectors of
average node activity state differences} between two groups of models where
the classification was based on the models' MCC values.
Rows represent the different classification group matchings, e.g. (1,2) means the
models that belonged to the 1st group of MCC values vs the models that
belonged to the 2nd group. The columns represent the network's node names.
Values are in the [-1,1] interval.
}
\description{
This function splits the Matthews correlation coefficient (MCC) scores
of the models to specific groups using the \pkg{Ckmeans.1d.dp}
package for the clustering (groups are denoted by ids, e.g. NaN,1,2,3, etc.
where a larger id corresponds to a group of models with higher MCC scores)
and for each pairwise
combination of group id matchings (e.g. (0,1), (1,3), etc.), it uses the
\code{\link{get_avg_activity_diff_based_on_mcc_clustering}}
function, comparing thus all groups of models that belong to different
MCC classes.
}
\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}}
}
\concept{average data difference functions}
