% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_model_predictions}
\alias{get_model_predictions}
\title{Load the models predictions data}
\usage{
get_model_predictions(model.predictions.file)
}
\arguments{
\item{model.predictions.file}{a tab-delimited file (for the specific format
check the example below)}
}
\value{
a \code{data.frame} object with rows the models and columns the
drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)
}
\description{
Use this function to read a file that has the model predictions data
and output it to a \code{data.frame} object.
}
\examples{

model.predictions.file = system.file("extdata", "model_predictions",
  package = "emba", mustWork = TRUE)
model.predictions = get_model_predictions(model.predictions.file)

}
