% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_avg_link_operator_diff_graph}
\alias{plot_avg_link_operator_diff_graph}
\title{Plot the graph of average link operator differences (igraph)}
\usage{
plot_avg_link_operator_diff_graph(net, diff, layout, title)
}
\arguments{
\item{net}{igraph graph object}

\item{diff}{numeric vector. Every value is in the [-1,1] interval and
represents the average link operator value difference of each node. The node
names have to be specified in the \emph{names} attribute of the given vector.
For example, \code{diff} could be the result of using the function
\code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}} and
getting one vector row from the output matrix.
A value closer to -1 means that the 'good' models have more of the \emph{AND NOT}
link operator in their respective boolean equations while a value closer to 1
means that the 'good' models have more of the \emph{OR NOT} link operator.}

\item{layout}{a (nx2) numeric matrix of x-y coordinates (2 columns) for each
of the nodes (n) in the \code{net} igraph object}

\item{title}{string. The title of the igraph plot}
}
\description{
This function uses the \code{\link[igraph]{igraph}} package to plot a network
of nodes. The nodes are positioned according to the specified coordinates
given by the \code{layout} parameter and the colors are derived using the
\code{diff} values and the \code{\link{get_node_colors}} function. The color
of each node indicates if the node's boolean function has on average the
\emph{AND NOT} or the \emph{OR NOT} link operator when comparing the average
model classified in the 'good' category vs the average bad' one. A non-colored
node (white) will indicate nodes that do not have the link operator in their
respective boolean equation (where they function as the target).
}
\seealso{
\code{\link{get_node_colors}}

Other network plotting functions: 
\code{\link{plot_avg_link_operator_diff_graphs}()},
\code{\link{plot_avg_state_diff_graph_vis}()},
\code{\link{plot_avg_state_diff_graphs}()},
\code{\link{plot_avg_state_diff_graph}()}
}
\concept{network plotting functions}
