% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.emdi.R
\name{subset.estimators.emdi}
\alias{subset.estimators.emdi}
\title{Subsets an estimators.emdi object}
\usage{
\method{subset}{estimators.emdi}(x, ...)
}
\arguments{
\item{x}{an object of type "estimators.emdi".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Selected subsets of the object of type "estimators.emdi".
}
\description{
Subsets an estimators.emdi object
}
\examples{
\donttest{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")

# Generate emdi object with deleting missing values; here via function ebp()
emdi_model <- ebp( fixed = eqIncome ~ gender + eqsize + cash +
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent +
fam_allow + house_allow + cap_inv + tax_adj,
pop_data = eusilcA_pop, pop_domains = "district",
smp_data = eusilcA_smp, smp_domains = "district",
na.rm = TRUE)

# Example: Choose last lines of the Gini coefficient, MSE and CV
subset(estimators(emdi_model, indicator = "Gini"),
       Domain \%in\% c("Wien", "Wien Umgebung"))
}
}
\seealso{
\code{\link{estimators.emdi}}
}
