% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hllf.R
\docType{methods}
\name{logLik,hspec-method}
\alias{logLik,hspec-method}
\title{Compute the log-likelihood function}
\usage{
\S4method{logLik}{hspec}(
  object,
  inter_arrival,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  N0 = NULL,
  lambda_component0 = NULL,
  ...
)
}
\arguments{
\item{object}{\code{\link{hspec-class}}. The parameter values in the object are used to compute the log-likelihood.}

\item{inter_arrival}{A vector of realized inter-arrival times of events which includes inter-arrival for events that occur in all dimensions. Start with zero.}

\item{type}{A vector of realized dimensions distinguished by numbers, 1, 2, 3, and so on. Start with zero.}

\item{mark}{A vector of realized mark (jump) sizes. Start with zero.}

\item{N}{A matrix of counting processes.}

\item{Nc}{A matrix of counting processes weighted by mark.}

\item{N0}{A matrix of initial values of N.}

\item{lambda_component0}{The initial values of lambda component. Must have the same dimensional matrix with \code{object}.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
The log-likelihood of the ground process of the Hawkes model.
(The log-likelihood for mark (jump) distribution is not provided.)
}
\seealso{
\code{\link{hspec-class}}, \code{\link{hfit,hspec-method}}
}
