% Generated by roxygen2 (4.0.1): do not edit by hand
\name{batch.model}
\alias{batch.model}
\title{Perform modeling}
\usage{
batch.model(proc, x, y, resample = emil::resample("crossval", y, nfold = 2,
  nrep = 2), pre.process = pre.split, .save = list(fit = FALSE, pred =
  FALSE, vimp = FALSE, tuning = FALSE), .parallel.cores = 1,
  .checkpoint.dir = NULL, .return.errors = .parallel.cores > 1,
  .verbose = FALSE)
}
\arguments{
\item{proc}{modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling.procedure}}.}

\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Response vector.}

\item{resample}{The test subsets used for parameter tuning. Leave blank to
randomly generate a resampling scheme of the same kind as is used by
\code{\link{batch.model}} to assess the performance of the whole
modeling procedure.}

\item{pre.process}{Function that performs pre-processing and splits dataset
into fitting and test subsets.}

\item{.save}{What aspects of the modeling to perform and return to the
user.}

\item{.parallel.cores}{Number of CPU-cores to use for parallel computation.
The current implementation is based on \code{\link{mcMap}}, which
unfortunatelly do not work on Windows systems. It can however be
re-implemented by the user fairly easily by setting up a PSOCK cluster and
calling \code{\link{parLapply}} as in the example below. This solution
might be included in future versions of the package, after further
investigation.}

\item{.checkpoint.dir}{Directory to save intermediate results to. If set
the computation can be restarted with minimal loss of results.}

\item{.return.errors}{If \code{FALSE} the entire modeling is aborted upon an
error. If \code{TRUE} the modeling of the particular fold is aborted and
the error message is returned instead of its results.}

\item{.verbose}{Whether to print an activity log. Set to \code{-1} to
also suppress output generated from the procedure's functions.}
}
\value{
A list tree where the top level corresponds to folds (in case of
  multiple folds), the next level corresponds to the modeling procedures
  (in case of multiple procedures), and the final level is specified by the
  \code{.save} parameter. It typically contains a subset of the following
  elements:
  \describe{
      \item{\code{error}}{Performance estimate of the fitted model. See
          \code{\link{error.fun}} for more information.}
      \item{\code{fit}}{Fitted model.}
      \item{\code{pred}}{Predictions given by the model.}
      \item{\code{vimp}}{Variable importance scores.}
      \item{\code{tune}}{Results from the parameter tuning. See
          \code{\link{tune}} for details.}
  }
}
\description{
This function is the core of the framework, carrying out most of the work.
It fits and evaluates models according to a resampling scheme, and extracts
variable importance scores.
Note that the typical user does not have to call this function
directly, but should use \code{\link{fit}}, \code{\link{tune}} or
\code{\link{evaluate.modeling}} instead.
}
\examples{
x <- iris[-5]
y <- iris$Species
proc <- modeling.procedure("lda")
cv <- resample("crossval", y, 4, 4)
perf <- batch.model(proc, x, y, cv, .save=list(pred=TRUE))

# Parallelization on windows
require(parallel)
cl <- makePSOCKcluster(2)
clusterEvalQ(cl, library(emil))
clusterExport(cl, c("proc", "x", "y"))
perf <- parLapply(cl, cv, function(fold)
    batch.model(proc, x, y, resample=fold))
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling.procedure}}
}

