% Generated by roxygen2 (4.0.1): do not edit by hand
\name{error.fun}
\alias{error.fun}
\alias{error.rate}
\alias{mse}
\alias{neg.auc}
\alias{neg.harrell.C}
\alias{rmse}
\title{Performance estimation functions}
\usage{
error.rate(true, pred)

neg.auc(true, pred)

rmse(true, pred)

mse(true, pred)

neg.harrell.C(true, pred)
}
\arguments{
\item{true}{The true response values, be it class labels, numeric values or
survival outcomes.}

\item{pred}{A prediction object.}
}
\description{
These functions determine the performance of fitted model based on its
predictions. They are used both for evaluating whole modeling procedures and
to tune model parameters, i.e. find the parameter values with the best
performance.
The parameter tuning routine is designed to minimize its error function (or
optimization criteria), which is why functions that are to be maximized must
have their sign changed, like \code{neg.auc}.
}
\details{
Custom performance estimation functions should be implemented as follows:

\code{function(true, pred)}
\describe{
    \item{\code{true}}{A vector of true responses.}
    \item{\code{pred}}{Prediction returned from the prediction function.}
}

In most cases the true response and the predictions are of the same type,
e.g. true and fitted values in a regression or class labels in a
classification problem, but it is not a requirement. An example of different
types could be if the prediction function produce class probabilities for
all classes rather than one label, or the risks that the observations will
experience the event of interest, to be compared to the actual outcome that
it did occur or has not yet occurred at a specific time point.
See neg.harrell.C for an example of the latter.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{neg.gmpa}},
  \code{\link{modeling.procedure}}, \code{\link{emil.extensions}}
}

