% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt_html_file.R
\name{encrypt_html_file}
\alias{encrypt_html_file}
\title{Encrypt an html file}
\usage{
encrypt_html_file(
  path,
  output_path = paste0(path, ".enc.html"),
  key = sodium::random(32L),
  message_key = TRUE,
  write_key_file = FALSE,
  output_template_path = system.file("html-template.html", package = "encryptedRmd")
)
}
\arguments{
\item{path}{the file you want to encrypt}

\item{output_path}{optional, the output path}

\item{key}{optional, the encryption key}

\item{message_key}{optional, print the encryption key to the console}

\item{write_key_file}{optional, write a key file in the same directory}

\item{output_template_path}{a path to the output template.
The output template needs have the same html form elements (same ids) and the same placeholders as the default template. Everything else can be customized.}
}
\value{
The key used to encrypt the file as an invisible raw vector.
}
\description{
This function takes an html file, encrypts the complete file using \code{\link[sodium:data_encrypt]{sodium::data_encrypt}}
and a given key. It then injects the encrypted content into an html template that
contains the \code{sodium} decryption code compiled to javascript.
The resulting file is fully self contained as it can decrypt itself.
When the user enters the correct key, the DOM of the html files gets replaced with
the initially encrypted html file.
}
\details{
Warning: You are using this at your own risk. Make sure your encryption key is
strong enough. For serious use cases, please also review the code of the functions.
Any feedback is appreciated. This is an early package version.
}
\references{
The package follows the same approach as the node module \href{https://github.com/derhuerst/self-decrypting-html-page}{self-decrypting-html-page}.
The decryption code is based on a number of great node modules.
All licenses are also bundled with each encrypted html file.
}
