% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biprobit_partial.R
\name{biprobit_partial}
\alias{biprobit_partial}
\title{Recursive Bivariate Probit Model with Partially Observed First Stage}
\usage{
biprobit_partial(
  form1,
  form2,
  data = NULL,
  EM = FALSE,
  par = NULL,
  method = "BFGS",
  verbose = 0,
  accu = 10000,
  maxIter = 500,
  tol = 1e-05,
  tol_LL = 1e-06
)
}
\arguments{
\item{form1}{Formula for the first probit model, in which the dependent variable is partially observed.}

\item{form2}{Formula for the second probit model, the partially observed dependent variable of the first stage is automatically added as a regressor in this model (do not add manually)}

\item{data}{Input data, a data frame}

\item{EM}{Whether to maximize likelihood use the Expectation-Maximization (EM) algorithm.}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm. Default is BFGS}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{maxIter}{max iterations for EM algorithm}

\item{tol}{tolerance for convergence of EM algorithm}

\item{tol_LL}{tolerance for convergence of likelihood}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate two probit models with bivariate normally distributed error terms, in which the dependent variable of the first stage model is partially observed (or unobserved)
}
\examples{
\donttest{
library(MASS)
N = 5000
rho = -0.5
set.seed(1)

x = rbinom(N, 1, 0.5)
z = rnorm(N)

e = mvrnorm(N, mu=c(0,0), Sigma=matrix(c(1,rho,rho,1), nrow=2))
e1 = e[,1]
e2 = e[,2]

y1 = as.numeric(1 + x + 3*z + e1 > 0)
y2 = as.numeric(1 + x + z + y1 + e2 > 0)

est = biprobit(y1~x+z, y2~x+z+y1)
est$estimates

observed_pct = 0.2
y1p = y1
y1p[sample(N, N*(1-observed_pct))] = NA
est_partial = biprobit_partial(y1p~x+z, y2~x+z)
est_partial$estimates
}
}
\references{
Peng, Jing. (2022) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research (Forthcoming), Available at SSRN: https://ssrn.com/abstract=3494856
}
\seealso{
Other endogeneity: 
\code{\link{bilinear}()},
\code{\link{biprobit_latent}()},
\code{\link{biprobit}()},
\code{\link{pln_linear}()},
\code{\link{pln_probit}()},
\code{\link{probit_linear_latent}()},
\code{\link{probit_linear_partial}()},
\code{\link{probit_linear}()}
}
\concept{endogeneity}
