% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefinite.R
\name{indefinite}
\alias{indefinite}
\alias{indefinite.numeric}
\alias{indefinite.english}
\alias{indefinite.ordinal}
\alias{indefinite.character}
\alias{Indefinite}
\title{Add Indefinite Article}
\usage{
indefinite(n, ...)

\method{indefinite}{numeric}(n, words = TRUE, ...)

\method{indefinite}{english}(n, words = TRUE, ...)

\method{indefinite}{ordinal}(n, ...)

\method{indefinite}{character}(n, ...)

Indefinite(n, ...)
}
\arguments{
\item{n}{either a numeric vector or a ordinal character string.}

\item{...}{Extra arguments, currently ignored}

\item{words}{logical: should the numbers be expressed as words (TRUE) or digits (FALSE)?}
}
\value{
A character string vector with an article prepended, either capitalized or not.
}
\description{
Adds an initial indefinite article "a" or "an" to a numerical
object expressed either as digits or as words in the result.
The capitalized form, \code{Initial}, capitalizes the initial
letter: "An" or "A".
}
\examples{
indefinite(1:12)
paste0(Indefinite(1:12, FALSE), "-stage process")
cat(paste(Indefinite(ordinal(1:10)), " point is ...\\n", sep = ""))
}
