% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_enrichwith_skeleton.R
\name{create_enrichwith_skeleton}
\alias{create_enrichwith_skeleton}
\title{Create a enrichwith skeleton}
\usage{
create_enrichwith_skeleton(class, option, description, component, path,
  filename = paste0(class, "_options.R"), attempt_rename = TRUE)
}
\arguments{
\item{class}{the class of the objects to be enriched}

\item{option}{a character vector with components the enrichment
options}

\item{description}{a character vector of length
\code{length(options)} with components the description of the
enrichment options}

\item{component}{a list of as many character vectors as
\code{length(option)}, specifying the names of the components
that each option will add to the object after enrichment}

\item{path}{the path where the skeleton file will be created}

\item{filename}{the name of the skeleton file}

\item{attempt_rename}{attempt to rename syntactically incorrect
component names? Default is \code{TRUE}}
}
\value{
A file with the necessary functions to use
    \code{enrichwith} infrastructure. The skeleton consists of the
    following functions
\itemize{

\item One \code{compute_component.class} function per component
name from \code{unique(unlist(component))}. The function takes as
input the object to be enriched and returns as output the component
to be added to the object.

\item The \code{get_enrichment_options.class} function, that takes
as input the object to be enriched and an enrichment option, and
returns the names of the components that will be appended to the
object for this option. This function can also be used to list the
available options and print their description.

\item The \code{enrich.class} function

}
}
\description{
Create an enrichwith skeleton file for the structured
implementation of methods to compute new components for objects of
a specific class
}
