#' Histology grade and risk factors for 79 cases of endometrial cancer
#'
#' @format A data frame with 79 rows and 4 variables:
#' \describe{
#'
#' \item{NV}{neovasculation with coding 0 for absent and 1 for present}
#'
#' \item{PI}{pulsality index of arteria uterina}
#'
#' \item{EH}{endometrium heigh}
#'
#' \item{HG}{histology grade with coding 0 for low grade and 1 for high grade}
#'
#' }
#'
#' @source The packaged data set was downloaded in \code{.dat} format
#'     from \url{http://www.stat.ufl.edu/~aa/glm/data}. The latter
#'     link provides the data sets used in Agresti (2015).
#'
#'     The endometrial data set was first analysed in Heinze and
#'     Schemper (2002), and was originally provided by Dr
#'     E. Asseryanis from the Medical University of Vienna.
#'
#'
#' Agresti, A. 2015. *Foundations of Linear and Generalized Linear
#' Models*.  Wiley Series in Probability and Statistics. Wiley.
#'
#' Heinze, G., and M. Schemper. 2002. “A Solution to the Problem of
#' Separation in Logistic Regression.” *Statistics in Medicine*
#' 21:2409–19.
#'
"endometrial"
