\name{envl.pval}
\Rdversion{1.1}
\alias{envl.pval}
\title{p-values for the envelope test.}
\description{
 Approximates the p-value used in the envelope test for the specified sample size and level.
}
\usage{
 envl.pval(n, alpha = 0.05, k = 10000)
}
\arguments{
  \item{n}{ sample size}
  \item{alpha}{ test level to be used, a number from 0 to 1}
  \item{k}{ number of samples to use in the simulation}
}
\details{
 The approximation is done using a Monte Carlo simulation. It calculates band limits of the form \code{qnorm(qbeta(p/2,m,n-m+1))} and \code{qnorm(qbeta(1-p/2,m,n-m+1))} where p is the desired value.
}
\value{
 The function returns the p-value for the specified sample size and level.
}
\references{W. Rolke, The envelope test, Unpublished manuscript, http://charma.uprm.edu/~rolke/publications.htm}
\author{Felipe Acosta}
\seealso{ 
 \code{\link{envl.plot}} for a function to perform the test, \code{\link{qqenvl}} to add an envelope to normality plot generated by \code{qqnorm} 
}
\examples{
 envl.pval(n=20,alpha=0.01);
}
\keyword{ htest }
