% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefscore.R
\name{enve.prefscore}
\alias{enve.prefscore}
\title{Enveomics: Pref Score}
\usage{
enve.prefscore(
  x,
  set,
  ignore = NULL,
  signif.thr,
  plot = TRUE,
  col.above = rgb(148, 17, 0, maxColorValue = 255),
  col.equal = rgb(189, 189, 189, maxColorValue = 255),
  col.below = rgb(47, 84, 150, maxColorValue = 255),
  ...
)
}
\arguments{
\item{x}{Occupancy matrix (logical or numeric binary) with species as rows and samples
as columns}

\item{set}{Vector indicating samples in the test set. It can be any selection vector:
boolean (same length as the number of columns in \code{x}), or numeric or
character vector with indexes of the \code{x} columns.}

\item{ignore}{Vector indicating species to ignore. It can be any selection vector with
respect to the rows in \code{x} (see \code{set}).}

\item{signif.thr}{Absolute value of the significance threshold}

\item{plot}{Indicates if a plot should be generated}

\item{col.above}{Color for points significantly above zero}

\item{col.equal}{Color for points not significantly different from zero}

\item{col.below}{Color for points significantly below zero}

\item{...}{Any additional parameters supported by \code{plot}}
}
\value{
Returns a named vector of preference scores.
}
\description{
Estimate preference score of species based on occupancy in biased sample sets
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
