% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoprune.R
\name{enve.prune.dist}
\alias{enve.prune.dist}
\title{Enveomics: Prune Dist}
\usage{
enve.prune.dist(
  t,
  dist.quantile = 0.25,
  min_dist,
  quiet = FALSE,
  max_iters = 100,
  min_nodes_random = 40000,
  random_nodes_frx = 1
)
}
\arguments{
\item{t}{A \strong{phylo} object or a path to the Newick file.}

\item{dist.quantile}{The quantile of edge lengths.}

\item{min_dist}{The minimum distance to allow between two tips.
If not set, \code{dist.quantile} is used instead to calculate it.}

\item{quiet}{Boolean indicating if the function must run without output.}

\item{max_iters}{Maximum number of iterations.}

\item{min_nodes_random}{Minimum number of nodes to trigger \emph{tip-pairs} nodes sampling. 
This sampling is less reproducible and more computationally expensive,
but it's the only solution if the cophenetic matrix exceeds \code{2^31-1} 
entries; above that, it cannot be represented in R.}

\item{random_nodes_frx}{Fraction of the nodes to be sampled if more than \code{min_nodes_random}.}
}
\value{
Returns a pruned \strong{phylo} object.
}
\description{
Automatically prunes a tree, to keep representatives of each clade.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
