% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mda.R
\name{findlipid}
\alias{findlipid}
\title{Find lipid class of metabolites base on referenced Kendrick mass defect}
\usage{
findlipid(list, mode = "pos")
}
\arguments{
\item{list}{list with data as peaks list, mz, rt and group information, retention time should be in seconds}

\item{mode}{'pos' for positive mode, 'neg' for negative mode and 'none' for neutral mass, only support [M+H] and [M-H] for each mode}
}
\value{
list list with dataframe with the lipid referenced Kendrick mass defect(RKMD) and logical for class
}
\description{
Find lipid class of metabolites base on referenced Kendrick mass defect
}
\examples{
data(list)
RKMD <- findlipid(list)
}
\references{
Method for the Identification of Lipid Classes Based on Referenced Kendrick Mass Analysis. Lerno LA, German JB, Lebrilla CB. Anal Chem. 2010 May 15;82(10):4236–45.
}
