% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_SE.R
\name{est_pk0}
\alias{est_pk0}
\title{Fit pk searcher efficiency models}
\usage{
est_pk0(pkdata, kFixed = NULL, n.iter = 1000, ...)
}
\arguments{
\item{pkdata}{Search trial data entered in a list of N-vectors, $n and $y,
indicating the number of carcasses available and the number discovered in
searcher efficiency field trials in which carcasses were available for
discovery. [NOTE: In earlier versions of \code{eoa}, the vectors were $M and
$X. The names have been changed to avoid confusion with the \code{M} and
\code{X} for total mortality and carcasses discovered carcass survey.]}

\item{kFixed}{If trial carcassses are available for discovery for one search
and data are insufficient for estimating \code{k}, a fixed, assumed value must
be entered for \code{k}.}

\item{n.iter}{number of iterations to use in updating the JAGS model for
\eqn{p} and \eqn{k}}

\item{...}{Other parameters that may be used in called functions (esp.
\code{burn} for updating the JAGS function)}
}
\value{
A list with an nsim x 2 matrix of simulated \code{p} and \code{k}
 values
 the joint posterior for SE.
}
\description{
Searcher efficiency is modeled as a function of the number of
 times a carcass has been missed in previous searches and any number of
 covariates.
}
\details{
The probability of finding a carcass that is present at the time of
 search is \code{p} on the first search after carcass arrival and is
 assumed to decrease by a factor of \code{k} each time the carcass is
 missed in searches.
}
