% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_M.R
\name{postM}
\alias{postM}
\alias{postM.ab}
\alias{calcMstar}
\alias{MCI}
\title{Calculate posterior distribution of M and extract statistics (M* and CI)}
\usage{
postM(x, g, prior = "IbinRef", mmax = NA)

postM.ab(x, Ba, Bb, prior = "IbinRef", mmax = NULL)

calcMstar(pMgX, alpha)

MCI(pMgX, crlev = 0.95)
}
\arguments{
\item{x}{carcass count}

\item{g}{overall carcass detection probability}

\item{prior}{prior distribution of \eqn{M}}

\item{mmax}{cutoff for prior of M (large max requires large computing resources
but does not help in the estimation)}

\item{Ba, Bb}{parameters for beta distribution characterizing estimated \eqn{g}}

\item{pMgX}{posterior distribution of \eqn{M}}

\item{crlev, alpha}{credibility level (\eqn{1-\alpha}) and its complement (\eqn{\alpha})}
}
\value{
The functions \code{postM} and \code{postM.ab} return the posterior
 distributions of \eqn{M | (X, g)} and \eqn{M | (X, Ba, Bb)}, respectively.
 The functions \code{calcMstar} and \code{MCI} return \eqn{M^*} value and
 credibility interval for the given posterior distribution, \code{pMgX}
 (which may be the return value of \code{postM} or \code{postM.ab}) and
 \eqn{\alpha} value or credibility level.
}
\description{
Calculation of the posterior distribution of total mortality
 (\code{M}) given the carcass count, overall detection probability (\code{g}),
 and prior distribtion; calculation of summary statistics from the
 posterior distribution of \code{M}, including \code{M*} and credibility
 intervals.
}
\details{
The functions \code{postM} and \code{postM.ab} return the posterior
 distributions of \eqn{M|(X, g)} and \eqn{M|(X, Ba, Bb)}, respectively, where
 \code{Ba} and \code{Bb} are beta distribution parameters for the estimated
 detection probability. \code{postM} and \code{postM.ab} include options to
 to specify a prior distribution for \eqn{M} and a limit for truncating the
 prior to disregard implausibly large values of \eqn{M} and make the
 calculations tractable in certain cases where they otherwise might not be.
 Use \code{postM} when \eqn{g} is fixed and known; otherwise, use \code{postM.ab}
 when uncertainty in \eqn{g} is characterized in a beta distribution with
 parameters \eqn{Ba} and \eqn{Bb}. The non-informative, integrated reference
 prior for binomial random variables is the default (\code{prior = "IbinRef"}).
 Other options include "binRef", "IbetabinRef", and "betabinRef", which are
 the non-integrated and integrated forms of the binomial and betabinomial
 reference priors (Berger et al., 2012). For \eqn{X > 2}, the integrated and
 non-integrated reference priors give virtually identical posteriors. However,
 the non-integrated priors assign infinite weight to \eqn{m = 0} and return a
 posterior of \eqn{Pr(M = 0| X = 0, \hat{g}) = 1}, implying absolute certainty
 that the total number of fatalities was 0 if no carcasses were observed. In
 addition, a uniform prior may be specified by prior = "uniform". Alternatively,
 a custom prior may be given as a 2-dimensional array with columns for \eqn{m}
 and \eqn{Pr(M = m)}, respectively. The first column (\code{m}) must be
 sequential integers starting at \eqn{m = 0}. The second column gives the
 probabilities associated with \eqn{m}, which must be non-negative and sum to 1.
 The named priors (\code{"IbinRef"}, \code{"binRef"}, \code{"IbetabinRef"},
 and \code{"betabinRef"}) are functions of \eqn{m} and defined on \eqn{m=0,1,2,...}
 without upper bound. However, the posteriors can only be calculated for a
 finite number of \eqn{m}'s up to a maximum of \code{mmax}, which is set by
 default to the smallest value of \eqn{m} such that
 \eqn{Pr(X \leq x | m, \hat{g}) < 0.0001}, where \eqn{x} is the observed
 carcass count, or, alternatively, \code{mmax} may be specified by the user.
}
