% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cepan.R
\name{cepan}
\alias{cepan}
\title{Calculate censoring point}
\usage{
cepan(ev, mu = 0, r = 5^0.5)
}
\arguments{
\item{ev}{expected value.}

\item{mu}{mean of distribution prior to censoring.}

\item{r}{half the range of the distribution, ie the distance from the mean to the smallest/largest value supported by the distribution. \code{r=5^.5} correspons to a standard deviation of 1.}
}
\value{
the censoring point associated with \code{ev}, \code{mu} and \code{r}.
}
\description{
This function calculates the censoring point of a random left-censored epanechnikov-distributed variable associated a given expected value.
The inverse of this function is \code{evepan}.
}
\examples{
cepan(ev=103,mu=100,r=16) #Expected value of an epan-distributed variable left-censored at 103
}
\keyword{distribution}

