% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydraulics.r
\name{ENopenH}
\alias{ENopenH}
\title{Open hydraulics analysis system.}
\usage{
ENopenH()
}
\value{
Returns NULL invisibly; called for side effect
}
\description{
\code{ENopenH} opens the EPANET hydraulics analysis system.
}
\details{
Call \code{ENopenH} prior to running the first hydraulic analysis using the 
  \code{ENinitH-ENrunH-ENnextH} sequence. Multiple analyses can be made before calling 
  \code{ENcloseH} to close the hydraulic analysis system.
  
  Do not call this function if \code{ENsolveH} is being used to run a complete hydraulic analysis.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENopenH()
ENinitH(0)
ENrunH()
ENcloseH()
ENclose()
# clean-up the created files
file.remove("Net1.rpt") 
}
\seealso{
\code{ENinitH}, \code{ENrunH}, \code{ENnextH}, \code{ENcloseH}
}
