% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{varimax}
\alias{varimax}
\title{Varimax Rotation}
\usage{
varimax(x, normalize = FALSE, eps = 1e-05, maxit = 1000L)
}
\arguments{
\item{x}{A loadings matrix, with \eqn{p} rows and \eqn{k < p} columns}

\item{normalize}{logical. Should Kaiser normalization be performed?
    If so the rows of \code{x} are re-scaled to unit length before
    rotation, and scaled back afterwards.}

\item{eps}{The tolerance for stopping: the relative change in the sum
    of singular values.}

\item{maxit}{\code{integer}, maximum number of iteration (default to 1,000).}
}
\value{
A list with three elements:
\item{rotated}{the rotated matrix.}
\item{rotmat}{the (orthogonal) rotation matrix.}
\item{n.iter}{the number of iterations taken.}
}
\description{
This is a re-implementation of \link[stats:varimax]{stats::varimax},
which (1) adds a parameter for the maximum number of iterations,
(2) sets the default \code{normalize} parameter to \code{FALSE},
(3) outputs the number of iteration taken, and
(4) returns regular \code{matrix} rather than in \code{loadings} class.
}
\seealso{
\link[stats:varimax]{stats::varimax}
}
