% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predation.R
\name{predation}
\alias{predation}
\title{Predation under IPCC RCP2.6 or RCP8.5 scenarios}
\usage{
predation(
  y_ini = c(V = 400, V = 400, V = 400, P = 200, P = 200, P = 200),
  temp_ini = rep(25, 3),
  temp_cmin = rep(18, 3),
  temp_cmax = c(25, 28, 32),
  ro = rep(0.7, 3),
  lambda = rep(5e-05, 3),
  e = rep(0.3, 3),
  mp = rep(0.08, 3),
  q = rep(0.7, 3),
  a = rep(800, 3),
  RCP = 2.6,
  time_start = 2005,
  time_end = 2100,
  leap = 1/50
)
}
\arguments{
\item{y_ini}{Initial population values (must be written with its name: N).}

\item{temp_ini}{Initial temperature.}

\item{temp_cmin}{Minimum critical temperature (prey).}

\item{temp_cmax}{Maximum critical temperature (prey).}

\item{ro}{Population growth rate at optimum temperature (prey).}

\item{lambda}{Marginal loss by non-thermodependent intraspecific competition (prey).}

\item{e}{Efficiency with which food is converted into population growth (predator).}

\item{mp}{Mortality rate (predator).}

\item{q}{Maximum per capita consumption rate (predator).}

\item{a}{Mean saturation rate (predator).}

\item{RCP}{Representative concentration trajectories (RCP2.6 and RCP8.5 scenarios).}

\item{time_start}{Start of time sequence.}

\item{time_end}{End of time sequence.}

\item{leap}{Time sequence step.}
}
\value{
(1) A data.frame with columns having the simulated trends.

(2) A four-panel figure where (a), (b), and (c) show the population abundance curves for each simulation.
       The brown curve corresponds to the abundance of prey and the green curve to predators. Panel (d)
       shows the temperature trend curves used for each simulation, green, blue, and black, respectively.
}
\description{
This function allows simulating the effect of the IPCC RCP2.6 or RCP8.5 scenarios
            (2014) on the abundances of two species interacting through predation. The prey is an
            ectotherm population, and the predator is not affected by temperature.
}
\details{
Three scenarios can be evaluated for a predation interaction where the prey is an ectotherm
        population. The temperature trends correspond to IPCC projections under the RCP2.6 or RCP8.5
        scenarios. In each input vector, the parameters for the three simulations must be specified.
}
\examples{

#######################################################################
  #Example 1: Different thermal tolerance ranges (scenario RCP2.6).
#######################################################################

temp_cmin <- 18

# Temperature that occurs before the minimum simulation time.
temp_i <- 22

time_end <- 2100

# Temperature that occurs in the maximum time of the simulation.
temp_max <- get_RCP2.6(time_end)+temp_i

# Simulation thermal range.
RS <- temp_max-temp_cmin

temp_cmax1 <- 4/3*RS+temp_cmin
temp_cmax2 <- 2/3*RS+temp_cmin
temp_cmax3 <- 1/3*RS+temp_cmin
temp_ini <- (temp_cmin+temp_cmax3)/2

predation(y_ini = c(V = 800, V = 800, V = 800,
                   P = 600, P = 600, P = 600),
         temp_ini = rep(temp_ini,3),
         temp_cmin = rep(temp_cmin,3),
         temp_cmax = c(temp_cmax1,temp_cmax2,temp_cmax3),
         ro = rep(0.7,3),
         lambda = rep(0.0004,3),
         e = rep(0.9,3),
         mp = rep(0.1,3),
         q = rep(0.7,3),
         a = rep(1000,3),
         RCP = 2.6,
         time_start = 2005,
         time_end = time_end,
         leap = 1/50)
\donttest{
#######################################################################
  #Example 2: Different thermal tolerance ranges (scenario RCP8.5).
#######################################################################

temp_cmin <- 18

# Temperature that occurs before the minimum simulation time.
temp_i <- 22

time_end <- 2100

# Temperature that occurs in the maximum time of the simulation.
temp_max <- get_RCP8.5(time_end)+temp_i

# Simulation thermal range.
RS <- temp_max-temp_cmin

temp_cmax1 <- 4/3*RS+temp_cmin
temp_cmax2 <- 2/3*RS+temp_cmin
temp_cmax3 <- 1/3*RS+temp_cmin
temp_ini <- (temp_cmin+temp_cmax3)/2

predation(y_ini = c(V = 800, V = 800, V = 800,
                   P = 600, P = 600, P = 600),
         temp_ini = rep(temp_ini,3),
         temp_cmin = rep(temp_cmin,3),
         temp_cmax = c(temp_cmax1,temp_cmax2,temp_cmax3),
         ro = rep(0.7,3),
         lambda = rep(0.0004,3),
         e = rep(0.9,3),
         mp = rep(0.1,3),
         q = rep(0.7,3),
         a = rep(1000,3),
         RCP = 8.5,
         time_start = 2005,
         time_end = time_end,
         leap = 1/50)

#######################################################################
  #Example 3: Different conversion efficiencies (scenario RCP2.6).
#######################################################################

e1 <- 0.2
e2 <- 2*e1
e3 <- 2*e2

predation(y_ini = c(V = 800, V = 800, V = 800,
                   P = 400, P = 400, P = 400),
         temp_ini = rep(22,3),
         temp_cmin = rep(20,3),
         temp_cmax = rep(35,3),
         ro = rep(0.9,3),
         lambda = rep(0.0006,3),
         e = c(e1,e2,e3),
         mp = rep(0.1,3),
         q = rep(0.7,3),
         a = rep(800,3),
         RCP = 2.6,
         time_start = 2005,
         time_end = 2100,
         leap = 1/50)

#######################################################################
  #Example 4: Different conversion efficiencies (scenario RCP8.5).
#######################################################################

e1 <- 0.2
e2 <- 2*e1
e3 <- 2*e2

predation(y_ini = c(V = 800, V = 800, V = 800,
                   P = 400, P = 400, P = 400),
         temp_ini = rep(22,3),
         temp_cmin = rep(20,3),
         temp_cmax = rep(35,3),
         ro = rep(0.9,3),
         lambda = rep(0.0006,3),
         e = c(e1,e2,e3),
         mp = rep(0.1,3),
         q = rep(0.7,3),
         a = rep(800,3),
         RCP = 8.5,
         time_start = 2005,
         time_end = 2100,
         leap = 1/50)
}
}
\references{
IPCC. (2014): Climate Change 2014: Synthesis Report. Contribution of Working Groups I,
           II and III to the Fifth Assessment Report of the Intergovernmental Panel on Climate
           Change [Core Writing Team, R.K. Pachauri and L.A. Meyer (eds.)]. IPCC, Geneva,
           Switzerland, 151 pp.
}
