% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph3D.R
\name{graph3D}
\alias{graph3D}
\title{Interactive 3D Force-directed graph from epicontacts object}
\usage{
graph3D(x, node_color = "id", annot = TRUE, col_pal = cases_pal,
  NA_col = "lightgrey", g_title = "", bg_col = "white",
  label_col = "darkgrey", node_size = 1, edge_size = 0.5)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object}

\item{node_color}{An index or character string indicating which field of the
linelist should be used to color the nodes. Default is \code{id}}

\item{annot}{An index, logical, or character string indicating which fields
of the linelist should be used for annotating the nodes upon mouseover. The default
\code{TRUE} shows the 'id' and 'node_color' (if the grouping column is different from 'id').}

\item{col_pal}{A color palette for the node_colors.}

\item{NA_col}{The color used for unknown node_color.}

\item{g_title}{The title of the graph.}

\item{bg_col}{The background color of graph.}

\item{label_col}{The color of the graph title and labels of groups.}

\item{node_size}{The sizes of graph nodes.}

\item{edge_size}{The width of graph edges.}
}
\value{
An htmlwidget object that is displayed using the object's show or print method.
(If you don't see your widget plot, try printing it with the \code{print} function.)
}
\description{
This function creates a 3D graph from an epicontacts object
}
\note{
All colors must be specified as color names like "red", "blue", etc. or
as hexadecimal color values without opacity channel, for example "#FF0000", "#0a3e55"
(upper or lower case hex digits are allowed).

Double-click or tap on the plot to reset the view.
}
\examples{
if (require(outbreaks)) {

## example using MERS outbreak in Korea, 2014
head(mers_korea_2015[[1]])
head(mers_korea_2015[[2]])

x <- make_epicontacts(linelist = mers_korea_2015$linelist,
                      contacts = mers_korea_2015$contacts,
                      directed = FALSE)

\dontrun{
graph3D(x)
graph3D(x, annot = FALSE)
graph3D(x, node_color = "sex", g_title = "MERS Korea 2014")
graph3D(x, node_color = "sex", annot = c("sex", "age"),
        g_title = "MERS Korea 2014")
}
}
}
\references{
Original rthreejs code by B. W. Lewis:
\url{https://github.com/bwlewis/rthreejs}.
}
\author{
Nistara Randhawa (\email{nrandhawa@ucdavis.edu})
Thibaut Jombart (\email{thibautjombart@gmail.com})
VP Nagraj (\email{vpnagraj@virginia.edu})
}
