% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epidatacall.R
\name{create_epidata_call}
\alias{create_epidata_call}
\alias{epidata_call}
\alias{fetch}
\title{An abstraction that holds information needed to make an epidata request}
\usage{
create_epidata_call(
  endpoint,
  params,
  meta = NULL,
  only_supports_classic = FALSE
)

fetch(epidata_call, fetch_args = fetch_args_list())
}
\arguments{
\item{endpoint}{the epidata endpoint to call}

\item{params}{the parameters to pass to the epidata endpoint}

\item{meta}{meta data to attach to the epidata call}

\item{only_supports_classic}{if true only classic format is supported}

\item{epidata_call}{an instance of \code{epidata_call}}

\item{fetch_args}{a \code{fetch_args} object}
}
\value{
\itemize{
\item For \code{create_epidata_call}: an \code{epidata_call} object
}

\itemize{
\item For \code{fetch}: a tibble or a JSON-like list
}
}
\description{
\code{epidata_call} objects are generated internally by endpoint functions like
\code{\link{pub_covidcast}}; by default, they are piped directly into the \code{fetch}
function to fetch and format the data. For most endpoints this will return
a tibble, but a few non-COVIDCAST endpoints will return a JSON-like list
instead.
}
\details{
\code{create_epidata_call} is the constructor for \code{epidata_call} objects, but you
should not need to use it directly; instead, use an endpoint function,
e.g., \code{\link{pub_covidcast}}, to generate an \code{epidata_call} for the data of
interest.

There are some other functions available for debugging and advanced usage: -
\code{request_url} (for debugging):  outputs the request URL from which data
would be fetched (note additional parameters below)

\code{fetch} usually returns the data in tibble format, but a few of the
endpoints only support the JSON classic format (\code{pub_delphi},
\code{pvt_meta_norostat}, and \code{pub_meta}). In that case a
JSON-like nested list structure is returned instead.
}
\examples{
\dontrun{
call <- pub_covidcast(
  source = "jhu-csse",
  signals = "confirmed_7dav_incidence_prop",
  time_type = "day",
  geo_type = "state",
  time_values = epirange(20200601, 20200801),
  geo_values = c("ca", "fl"),
  fetch_args = fetch_args_list(dry_run = TRUE)
)
call \%>\% fetch()
}

}
