% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.epimodel}
\alias{plot.epimodel}
\title{Plot method for epimodel objects}
\usage{
\method{plot}{epimodel}(
  x,
  plotfun = "intervals",
  pars = NULL,
  regex_pars = NULL,
  par_models = NULL,
  par_types = c("fixed", "aux", "seeds"),
  par_groups = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{plotfun}{Same as in \code{\link[rstanarm]{plot.stanreg}}.
A character string giving the name of the \pkg{bayesplot}
\link[bayesplot:MCMC-overview]{MCMC} function to use. These can be
listed using \code{\link[bayesplot]{available_mcmc}}. Defaults to "interval"}

\item{pars}{A character vector giving parameter names.}

\item{regex_pars}{A character vector of regular expressions to select parameters.
If pars is also used, regex_pars is used in conjunction with pars.}

\item{par_models}{A character vector that restricts parameters to a subset of
model components. For example, "R" only uses parameters in the transmission model,
"inf" uses parameters in infection model. Strings giving the name of the
response in an observation model (i.e. LHS of the \code{formula} in \code{epiobs})
can also be used. If NULL (the default), all components are used.}

\item{par_types}{A character vector that restricts parameters based on their
type. The vector can include any of "fixed", "autocor", "random", "aux", "latent",
or "seeds". The default is c("fixed", "aux", "seeds"), to avoid printing a
very large number of parameters. If NULL, all types are used.}

\item{par_groups}{A character vector restricting parameters to those
used for a subset of regions in which the epidemic is modeled. Defaults to
NULL in which case all regions are used.}

\item{...}{Arguments passed on to the \pkg{bayesplot} function specified by
\code{plotfun}.}
}
\value{
Either a ggplot object that can be further customized using the
\pkg{ggplot2} package, or an object created from multiple ggplot objects
(e.g. a gtable object created by \code{\link[gridExtra]{arrangeGrob}}).
}
\description{
Provides an interface to the \link[bayesplot:MCMC-overview]{MCMC} module
in the \pkg{\link{bayesplot}} package, and allows seamless plotting of
MCMC draws along with various diagnostics. This method relies heavily
on the code base for the \code{\link[rstanarm]{plot.stanreg}} method
in \pkg{rstanarm}.
}
\seealso{
\itemize{
\item \code{\link[rstanarm]{plot.stanreg}}.
\item \pkg{bayesplot} vignettes for examples.
\item \code{\link[bayesplot]{MCMC-overview}} (\pkg{bayesplot}) for plotting
function documentation.
\item \code{\link[bayesplot:bayesplot-colors]{color_scheme_set}} (\pkg{bayesplot}) to set
plotting color scheme.
}
}
