% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{gillespie}
\alias{gillespie}
\title{Gillespie exact algorithm}
\usage{
gillespie(rateqs, eventmatrix, parameters, initialvals, numevents)
}
\arguments{
\item{rateqs}{a list with rate equations}

\item{eventmatrix}{a matrix of changes in state variables associated with each event}

\item{parameters}{a vector of parameter values}

\item{initialvals}{a vector of initial values for the states}

\item{numevents}{number of events to be simulated}
}
\value{
A data frame with simulated time series
}
\description{
Function simulating a dynamical system using the Gillespie exact algorithm
}
\examples{
rlist=c(quote(mu * (S+I+R)), quote(mu * S), quote(beta * S * I /(S+I+R)), 
 quote(mu * I), quote(gamma * I), quote(mu*R))
emat=matrix(c(1,0,0,-1,0,0,-1,1,0,0,-1,0,0,-1,1,0,0,-1),ncol=3, byrow=TRUE)
paras  = c(mu = 1, beta =  1000, gamma = 365/20)
inits = c(S=100, I=2, R=0)
sim=gillespie(rlist, emat, paras, inits, 100)
}
