% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getGeno}
\alias{getGeno}
\title{Get population unphased genotypes.}
\usage{
getGeno(pop)
}
\arguments{
\item{pop}{a valid \code{Population} object.}
}
\value{
Returns an unphased genotypes matrix.
}
\description{
Retrieves the current unphased genotypes in the population.
}
\details{
\code{getGeno} retrieves the current unphased genotypes in the population,
returning a single matrix with one individual per row and one SNP per
column.
}
\examples{
# Construct a population
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)

# Retrieve genotypes
geno <- getGeno(pop)
}
\seealso{
\code{\link{Population}}, \code{\link{getPhased}}, \code{\link{getHaplo}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
