% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plot.Population}
\alias{plot.Population}
\title{Plot phenotypic value for a population.}
\usage{
\method{plot}{Population}(x, ...)
}
\arguments{
\item{x}{an object of class \code{'Population'} which has been run
in the simulator}

\item{...}{additional parameters (ignored)}
}
\value{
A plot of the population's simulation run is displayed.
}
\description{
Plot the phenotypic value for a population over the course of a
prior simulation run.
}
\details{
The plot is a line graph depicting the mean, minimum and maximum
phenotypic value in the population across generations. This method
can only be used if the population has been run via the simulator.
}
\examples{
# Build a population
pop <- Population(
  popSize = 100, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100), broadH2 = 0.9,
  narrowh2 = 0.5, traitVar = 40
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Run population in simulation
pop <- runSim(pop)

# Plot population's run
plot(pop)
}
\seealso{
\code{\link{Population}}, \code{\link{runSim}},
  \code{\link{addEffects}}, \code{\link{attachEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
