% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiHSIC.R
\name{epiHSIC2genos}
\alias{epiHSIC2genos}
\title{Calculate epistasis using HSIC with two genotype inputs}
\usage{
epiHSIC2genos(geno1 = NULL, geno2 = NULL, pheno = NULL,
  chunk = 1000, zpthres = 1e-05, outfile = "NONE", suffix = ".txt",
  ...)
}
\arguments{
\item{geno1}{is the first normalized genotype data. It can be a matrix or a dataframe, or a big.matrix object from \pkg{bigmemory}. 
The columns contain the information of variables and the rows contain the information of samples.}

\item{geno2}{is the second normalized genotype data. It can be a matrix or a dataframe, or a big.matrix object from \pkg{bigmemory}.
The columns contain the information of variables and the rows contain the information of samples.}

\item{pheno}{is a vector containing the normalized phenotype information.}

\item{chunk}{is the number of variants in each chunk.}

\item{zpthres}{is the significance threshold for cut-off output of the variant pairs.}

\item{outfile}{is the basename of out filename.}

\item{suffix}{is the suffix of out filename.}

\item{...}{not used}
}
\value{
null
}
\description{
Calculate the significance of epistasis according the definition of HSIC, conduct Z test for HSIC values and 
choose variant pairs with the significance below the given threshold for output.
}
\examples{
# simulate some data
set.seed(123)
n1 <- 10; n2 <- 15; rows <- 10
geno1 <- matrix(sample(0:2, size = n1*rows, replace = TRUE, prob = c(0.5, 0.3, 0.2)), ncol = n1)
geno2 <- matrix(sample(0:2, size = n2*rows, replace = TRUE, prob = c(0.4, 0.3, 0.3)), ncol = n2)
dimnames(geno1) <- list(row = paste0("IND", 1:nrow(geno1)), col = paste0("rs", 1:ncol(geno1)))
dimnames(geno2) <- list(row = paste0("IND", 1:nrow(geno2)), col = paste0("exm", 1:ncol(geno2)))
p2 <- rnorm(rows, mean = 5, sd = 10)

# normalized data
geno1 <- scale(geno1)
geno2 <- scale(geno2)
p2 <- as.vector(unlist(scale(p2)))

# two genotypes with quantitative phenotype
epiHSIC2genos(geno1 = geno1, 
geno2 = geno2, 
pheno = p2, 
outfile = "episcan_2geno_quant", 
suffix = ".txt", 
zpthres = 0.9, 
chunk = 10)

# take a look at the result
res <- read.table("episcan_2geno_quant.txt", 
header = TRUE, 
stringsAsFactors = FALSE)
head(res)
}
