% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{mak}
\alias{mak}
\title{Create 'mak' (Mass Action Kinetics) object}
\usage{
mak(A, B, s = solver(), r = NULL, rx0 = reg("none", lower = 0, upper =
  Inf, fixed = TRUE))
}
\arguments{
\item{A}{The reactant stoichiometric matrix (pxd) containing non-negative values. Here p is the number of parameters and d the number of species.}

\item{B}{The product stoichiometric matrix (pxd) containing non-negative values. Here p is the number of parameters and d the number of species.}

\item{s}{\code{\link{solver}} object.}

\item{r}{An object of class \code{\link{reg}} giving info about how to regularise and bound the rate parameters. If not provided, the default one is used.}

\item{rx0}{An object of class \code{\link{reg}} giving info about how to regularise and bound the initial state parameter. If not provided, the default one is used. This default \code{reg} sets \code{fixed = TRUE}, which is generally recommended.}
}
\value{
An object with S3 class "mak" and "ode".
}
\description{
This function creates an object of class \code{mak} (subclass of \code{ode}), which holds the basic information of the Mass Action Kinetics system in question.
}
\details{
Mass Action Kinetics is a class of ODE systems, having the following vector field:
\deqn{\frac{dx}{dt} = (B - A)^T diag(x^A) k}
with \eqn{x^A = (\prod_{i=1}^dx_i^{A_{ji}})_{j=1}^p} and \eqn{k} estimatable and non-negative.
}
\examples{
# Michaelis-Menten system
A <- matrix(
c(1, 1, 0, 0,
  0, 0, 1, 0,
  0, 0, 1, 0), ncol = 4, byrow = TRUE)
B <- matrix(
c(0, 0, 1, 0,
  1, 1, 0, 0,
  1, 0, 0, 1), ncol = 4, byrow = TRUE)
k <- c(1, 2, 0.5)
x0 <- c(E = 1, S = 4, ES = 0, P = 0)
Time <- seq(0, 1, by = .1)

m <- mak(A, B)

# Solve system
numsolve(m, Time, x0, k)

# Evaluate field
field(m, x0, k)

}
\seealso{
ode, numsolve, field
}
