\name{as.month}

\alias{as.month}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{Convert dates into months of the year for plotting epidemic curves}

\description{
  Converts dates into months of the year (1-12); but also creates range
  of calendar months that can be used to plot an epidemic curve
}

\usage{
as.month(x, format = "\%Y-\%m-\%d",
         min.date, max.date, before = 31, after = 31,
         origin = as.Date("1970-01-01"), abbreviate = TRUE)
}
%- maybe also 'usage' for other objects documented here.

\arguments{
  \item{x}{
    character vector of dates
  }
  \item{format}{
    date format of \code{x}; default is of form "2004-08-10" 
  }
  \item{min.date}{
    [optional] minimum calendar date for plotting x-axis of an epidemic
    curve; should be of the form of "2004-08-10"; if no date is
    specified, then several days are subtracted from the minimum date in
    \code{x} as specified by the \code{before} option
  }
  \item{max.date}{
    [optional] maximum calendar date for plotting x-axis of an epidemic
    curve plot; should be f the form of "2004-08-10"; if no date is
    specified, then several days are added to the maximum date in
    \code{x} as specified by the \code{after} option
  }
  \item{before}{
    if \code{min.date} is not specified, then these number of days are
    subtracted from the minimum date in \code{x} for plotting minimum
    calendar date for epidemic curve
  }
  \item{after}{
    if \code{max.date} is not specified, then these number of days are
    added to the maximum date in \code{x} for plotting maximum calendar
    date for epidemic curve 
  }
  \item{origin}{
    allows user to specify an alternative origin for Julian dates that
    are generated by this function (default = "1970-01-01")
  }
  \item{abbreviate}{
    abbreviate month names to Jan, Feb, Mar, etc.; often used for
    labeling plots
  }
}

\details{
  This function converts dates to months (1-12). In addition, a range of
  calendar months are generated that can be used to plot the x-axis of
  an epidemic curve. 
}

\value{
  Returns a list of the following:
  \item{$dates}{
    input dates are converted to standard calendar date format
  }
  \item{$mon}{
    month of the year (1-12)
  }
  \item{$month}{
    month of the year (Jan, Feb, Mar, ...)
  }
  \item{$stratum}{
    the Julian date for the mid-month day of the \code{$mon} value
  }
  \item{$stratum2}{
    the Julian date for the mid-month day of the \code{$mon} value
    converted to a factor with levels determined by the Julian dates
    (\code{$cstratum})used to plot an epidemic curve
  }
  \item{$stratum3}{
    the mid-month day of the \code{$mon} value converted to standard
    calendar dates
  }
  \item{$cmon}{
    the month of the year (1-12) used for plotting the x-axis of the
    epidemic curve
  }
  \item{$cmonth}{
    the months (Jan, Feb, Mar, ...) for the calendar dates used for
    plotting the x-axis of an epidemic curve
  }
  \item{$cstratum}{
    the Julian date for the mid-month day of the \code{$cmonth} value
    used for plotting the x-axis of an epidemic curve
  }
  \item{$cstratum2}{
    the standard calendar date for the mid-month day of the
    \code{$cmonth} value used for plotting the x-axis of an epidemic
    curve 
  }
  \item{$cmday}{
    the day of the mon (1-31) for the calendar dates used for plotting
    the x-axis of an epidemic curve
  }
  \item{$cyear}{
    the years (e.g., 1996, 2001, ...) for the calendar dates used for
    plotting the x-axis of the epidemic curve
  }
}

\references{none}

\author{Tomas Aragon, \email{aragon@berkeley.edu}, \url{http://www.medepi.net/aragon}}

\note{Visit \url{http://www.epitools.net} for the latest.}

\seealso{
  epitools: \code{\link{as.week}}, \code{\link{epicurve.dates}}
  
  \code{\link[base]{as.Date}}, \code{\link[base]{strptime}},
  \code{\link[based]{DateTimeClasses}}}

\examples{
dates <- c("1/1/04", "1/2/04", "1/3/04", "1/4/04", "1/5/04", "1/6/04",
"1/7/04", "1/8/04", "1/9/04", "1/10/04", NA, "1/12/04", "1/14/04",
"3/5/04", "5/5/04", "7/6/04", "8/18/04", "12/13/05", "1/5/05",
"4/6/05", "7/23/05", "10/3/05")
aw <- as.month(dates, format = "\%m/\%d/\%y")
aw

aw2 <- as.month(dates, format = "\%m/\%d/\%y", min.date="2003-01-01")
aw2

}

\keyword{chron}
