% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhcII-hu.R
\name{mhcII_hu}
\alias{mhcII_hu}
\title{Prediction of Nonself Peptide Presentation on Human MHC Class II}
\usage{
mhcII_hu(
  ag_present,
  ag_stim,
  ag_self,
  seq_len = "15",
  fd_out = as.character(paste0(tempdir(), "/", "outputs", "/")),
  method = "netmhciipan",
  cutoff_score = list(cutoff_netpan = c(50, 500), cutoff_comblib = c(50, 500),
    cutoff_nn_align = c(50, 500), cutoff_sturniolo = c(2), cutoff_el = c(2, 10)),
  cutoff_rank = c(2, 10),
  url_iedb = "http://tools-cluster-interface.iedb.org/tools_api/mhcii/"
)
}
\arguments{
\item{ag_present}{character vector, presenting allele, formatted with either "_", "*", or":" separating loci, antigen, and allele. For example, "DRB1_08_01".}

\item{ag_stim}{character vector, stimulating antigen, can either be an HLA class II allele entered in the same format as ag_present, or a character vector of the amino acid sequence of the protein}

\item{ag_self}{character, self antigen, can either be an HLA class II allele entered in the same format as ag_present, or a character vector of the amino acid sequence of the protein}

\item{seq_len}{string, length of peptides to consider}

\item{fd_out}{string, output folder name; default output is current working directory}

\item{method}{string, IEDB prediction method to be used. Options are "netmhciipan', "netmhciipan_el" or "recommended." Default is netmhciipan.}

\item{cutoff_score}{list of vectors. Defines the thresholds required to be included in results, and to be labeled, "strong" or "weak" binder. Multiple prediction methods are used, each of which provide different raw outputs (i.e. IC50, "strength", "score"). Our justification for the default thresholds is listed in the mhcII_hu vignette, however the user may choose to specify alternate cutoffs if desired.}

\item{cutoff_rank}{vector, IEDB adjusts all outputs in comparison to a set of random natural peptides in order to determine an normalized adjusted percentile rank. With normalized ranks, the same thresholds can be used across different methods. Default thresholds are <2\% for strong binders and <10\% for weak binders.}

\item{url_iedb}{string, iedb api url}
}
\value{
data frame, MHC II binding prediction result table
}
\description{
It determines which non-self peptides can be presented by a given HLA class II allele. This function takes a sequence for a stimulating antigen and the corresponding self antigen, and given a defined sequence length, queries the IEDB API with the user's choice of peptide binding prediction method. The set of peptides present in the results for the stimulating antigen but not the self antigen are then carried forward as non-self peptides. If desired, the user can adjust the default thresholds (by IC50 binding affinity or percentile rank) used to define "strong" and "weak" binders. The output is a dataframe of non-self peptides that are predicted to bind to the presenting allele.
}
\examples{
\donttest{
mhcII_hu(ag_present=c("DRB1_08_01"),ag_stim=c("DQA1_01_01","DQA1_04_01"),ag_self=c("DQA1_02_01"))
}
}
