% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{valuesets}
\alias{valuesets}
\title{Get the available EQ-5D value sets.}
\usage{
valuesets(type = NULL, version = NULL, country = NULL)
}
\arguments{
\item{type}{string EQ-5D value set type. TTO or VAS for EQ-5D-3L, VT for EQ-5D-5L,
CW for EQ-5D-5L crosswalk conversion dataset, or DSU for NICE Decision Support
Unit's EQ-5D-5L to EQ-5D-3L and EQ-5D-3L to EQ-5D-5L mappings.}

\item{version}{string either 3L or 5L.}

\item{country}{string one of the countries for which there is a value set.}
}
\value{
A data.frame containing the EQ-5D version, value set type and country
}
\description{
\code{valuesets} returns a data.frame of the available EQ-5D value sets
    in the \code{eq5d} package.
}
\examples{
valuesets()
valuesets(type="TTO")
valuesets(version="5L")
valuesets(country="UK")
}
