\name{drop.peakfeat}
\alias{drop.peakfeat}
\title{Erase peak features in peak object}
\description{
Erase chosen peak features informations from a \code{peak} object.
}
\usage{
drop.peakfeat(peak, feat)
}
\arguments{
	\item{peak}{ An object of class \code{peak}. See \code{define.peak} function for details. }
	\item{feat}{ A character string vector containing the names of the features to delete. Features could be: \code{"additive.effect"},\code{"peak.bp"},\code{"inf.bp"},\code{"sup.bp"} or \code{"type"}. See \code{calc.adef}, \code{localize.qtl},\code{classify.qtl} functions for details.}
}
\details{ In \code{peak} object, QTL is defined by peak features. This function is useful to erase some peak features by avoiding to re-perform all the analyses (mainly the \code{define.peak} function). Only the peak features generated by the functions \code{calc.adef}, \code{localize.qtl} and \code{classify.qtl} should be removed. This function is used by the functions 'calc.adef', 'localize.qtl' and 'classify.qtl'.
}
\value{ An object of class \code{peak} }
\author{ Hamid A. Khalili }
\seealso{\code{define.peak},\code{localize.qtl},\code{calc.adef},\code{classify.qtl}}
\examples{

data(seed10);

seed10 <- calc.genoprob( cross=seed10, step=2, off.end=0, error.prob=0,
	 map.function='kosambi', stepwidth='fixed');
seed10 <- sim.geno( cross=seed10, step=2, off.end=0, error.prob=0,
	 map.function='kosambi', stepwidth='fixed');

out.em <- scanone( seed10, pheno.col=1:50, model='normal', method='em')
out.peak <- define.peak(out.em,lodcolumn='CATrck');
out.peak <- calc.adef(seed10,out.em,out.peak)

out.peak;

data(BSpgmap);
out.peak <- localize.qtl(seed10,out.peak,BSpgmap);

out.peak;

out.peak <- drop.peakfeat(out.peak,'additive.effect');
out.peak <- drop.peakfeat(out.peak,c('inf.bp','sup.bp'));

out.peak;
}
\keyword{utilities}

