\name{mean.freqtab}
\Rdversion{1.1}
\alias{mean.freqtab}
\title{Mean of a Frequency Table}
\description{
This function returns the mean of a frequency table of class \dQuote{\code{\link{freqtab}}}
}
\usage{
mean.freqtab(x, ...)
}
\arguments{
  \item{x}{
two-column matrix of class \dQuote{\code{\link{freqtab}}}, where column 1 specifies the score scale and column 2 the frequencies for each score point
}
  \item{\dots}{
further arguments passed to or from other methods
}
}
\value{
}
\author{
Anthony Albano \email{tony.d.albano@gmail.com}
}
\seealso{
\code{\link{freqtab}}, \code{\link{var.freqtab}}
}
\examples{
set.seed(2005)
x <- round(rnorm(1000,100,10))
xscale <- 70:130
xtab <- freqtab(x,xscale)
mean.freqtab(xtab); mean(x)
}
\keyword{univar}