% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erah.R
\name{newExp}
\alias{newExp}
\title{New Experiment}
\usage{
newExp(instrumental, phenotype = NULL, info = character())
}
\arguments{
\item{instrumental}{A data.frame containing the sample instrumental information.}

\item{phenotype}{(optional) A data.frame containing sample phenotype information.}

\item{info}{Experiment description}
}
\value{
\code{newExp} returns an S4 object of the class 'MetaboSet'.
}
\description{
Sets a new experiment for eRah
}
\details{
See eRah vignette for more details. To open the vignette, execute the following code in R:
vignette("eRahManual", package="erah")
}
\examples{
\dontrun{
library(gcspikelite)
data(targets)

files <- list.files(system.file('data',package = 'gcspikelite'),full.names = TRUE)
files <- files[sapply(files,grepl,pattern = 'CDF')]

instrumental <- createInstrumentalTable(files)
phenotype <- createPhenoTable(files,as.character(targets$Group[order(targets$FileName)]))

ex <- newExp(instrumental = instrumental, 
phenotype = phenotype, info = "DEMO Experiment")
}
}
\references{
[1] Xavier Domingo-Almenara, et al., eRah: A Computational Tool Integrating Spectral Deconvolution and Alignment with Quantification and Identification of Metabolites in GC-MS-Based Metabolomics. Analytical Chemistry (2016). DOI: 10.1021/acs.analchem.6b02927
}
\seealso{
\code{\link{createInstrumentalTable}} \code{\link{createPhenoTable}} \code{\link{setDecPar}} \code{\link{setAlPar}}
}
\author{
Xavier Domingo-Almenara. xavier.domingo@urv.cat
}
