% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.ergm.bridge.R, R/control.logLik.ergm.R
\name{control.ergm.bridge}
\alias{control.ergm.bridge}
\alias{control.logLik.ergm}
\title{Auxiliaries for Controlling \code{\link[=ergm.bridge.llr]{ergm.bridge.llr()}} and \code{\link[=logLik.ergm]{logLik.ergm()}}}
\usage{
control.ergm.bridge(
  bridge.nsteps = 16,
  bridge.target.se = NULL,
  bridge.bidirectional = TRUE,
  MCMC.burnin = MCMC.interval * 128,
  MCMC.burnin.between = max(ceiling(MCMC.burnin/sqrt(bridge.nsteps)), MCMC.interval *
    16),
  MCMC.interval = 128,
  MCMC.samplesize = 16384,
  obs.MCMC.burnin = obs.MCMC.interval * 128,
  obs.MCMC.burnin.between = max(ceiling(obs.MCMC.burnin/sqrt(bridge.nsteps)),
    obs.MCMC.interval * 16),
  obs.MCMC.interval = MCMC.interval,
  obs.MCMC.samplesize = MCMC.samplesize,
  MCMC.prop = trim_env(~sparse),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  obs.MCMC.prop = MCMC.prop,
  obs.MCMC.prop.weights = MCMC.prop.weights,
  obs.MCMC.prop.args = MCMC.prop.args,
  MCMC.maxedges = Inf,
  MCMC.packagenames = c(),
  term.options = list(),
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)

control.logLik.ergm(
  bridge.nsteps = 16,
  bridge.target.se = NULL,
  bridge.bidirectional = TRUE,
  MCMC.burnin = NULL,
  MCMC.interval = NULL,
  MCMC.samplesize = NULL,
  obs.MCMC.samplesize = MCMC.samplesize,
  obs.MCMC.interval = MCMC.interval,
  obs.MCMC.burnin = MCMC.burnin,
  MCMC.prop = NULL,
  MCMC.prop.weights = NULL,
  MCMC.prop.args = NULL,
  obs.MCMC.prop = MCMC.prop,
  obs.MCMC.prop.weights = MCMC.prop.weights,
  obs.MCMC.prop.args = MCMC.prop.args,
  MCMC.maxedges = NULL,
  MCMC.packagenames = NULL,
  term.options = NULL,
  seed = NULL,
  parallel = NULL,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)
}
\arguments{
\item{bridge.nsteps}{Number of geometric bridges to use.}

\item{bridge.target.se}{If not \code{NULL}, if the estimated MCMC standard error of the likelihood estimate exceeds this, repeat the bridge sampling, accumulating samples.}

\item{bridge.bidirectional}{Whether the bridge sampler first bridges from \code{from} to \code{to}, then from \code{to} to \code{from} (skipping the first burn-in), etc. if multiple attempts are required.}

\item{MCMC.burnin}{Number of proposals before any MCMC sampling is done. It
typically is set to a fairly large number.}

\item{MCMC.burnin.between}{Number of proposals between the bridges; typically, less and less is needed as the number of steps decreases.}

\item{MCMC.interval}{Number of proposals between sampled statistics.}

\item{MCMC.samplesize}{Number of network statistics, randomly drawn from a
given distribution on the set of all networks, returned by the
Metropolis-Hastings algorithm.}

\item{obs.MCMC.burnin, obs.MCMC.burnin.between, obs.MCMC.interval, obs.MCMC.samplesize}{The \code{obs}
versions of these arguments are for the unobserved data simulation
algorithm.}

\item{MCMC.prop}{Specifies the proposal (directly) and/or
a series of "hints" about the structure of the model being
sampled. The specification is in the form of a one-sided formula
with hints separated by \code{+} operations. If the LHS exists and is
a string, the proposal to be used is selected directly.

A common and default "hint" is \code{~sparse}, indicating
that the network is sparse and that the sample should put roughly
equal weight on selecting a dyad with or without a tie as a
candidate for toggling.}

\item{MCMC.prop.weights}{Specifies the proposal
distribution used in the MCMC Metropolis-Hastings algorithm.  Possible
choices depending on selected \code{reference} and \code{constraints}
arguments of the \code{\link[=ergm]{ergm()}} function, but often include \code{"TNT"}
and \code{"random"}, and the \code{"default"} is to use the one with the
highest priority available.}

\item{MCMC.prop.args}{An alternative, direct way of
specifying additional arguments to proposal.}

\item{obs.MCMC.prop, obs.MCMC.prop.weights, obs.MCMC.prop.args}{The \code{obs} versions of these arguments are for the unobserved data simulation algorithm.}

\item{MCMC.maxedges}{The maximum number of edges that may occur during the MCMC sampling. If this number is exceeded at any time, sampling is stopped immediately.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[=set.MT_terms]{set.MT_terms()}} setting.}

\item{\dots}{A dummy argument to catch deprecated or mistyped control parameters.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary functions as user interfaces for fine-tuning the
\code{\link[=ergm.bridge.llr]{ergm.bridge.llr()}} algorithm, which approximates log likelihood
ratios using bridge sampling.

By default, the bridge sampler inherits its control
parameters from the \code{\link[=ergm]{ergm()}} fit; \code{control.logLik.ergm()} allows
the user to selectively override them.
}
\details{
\code{control.ergm.bridge()} is only used within a call to the
\code{\link[=ergm.bridge.llr]{ergm.bridge.llr()}}, \code{\link[=ergm.bridge.dindstart.llk]{ergm.bridge.dindstart.llk()}}, or
\code{\link[=ergm.bridge.0.llk]{ergm.bridge.0.llk()}} functions.

\code{control.logLik.ergm()} is only used within a call to the
\code{\link[=logLik.ergm]{logLik.ergm()}}.
}
\seealso{
\code{\link[=ergm.bridge.llr]{ergm.bridge.llr()}}

\code{\link{logLik.ergm}}
}
\keyword{models}
