% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{b1cov-ergmTerm}
\alias{b1cov-ergmTerm}
\alias{InitErgmTerm.b1cov}
\alias{InitWtErgmTerm.b1cov}
\title{Main effect of a covariate for the first mode in a bipartite network}
\usage{
# binary: b1cov(attr)

# valued: b1cov(attr, form="sum")
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds a single network statistic for each quantitative attribute or matrix column to the model equaling the total
value of \code{attr(i)} for all edges /eqn{(i,j)} in the network. This
term may only be used with bipartite networks. For categorical attributes,
see \code{b1factor} .
}
\note{
\pkg{ergm} versions 3.9.4 and earlier used different arguments for this
term. See \code{\link{ergm-options}} for how to invoke the old behaviour.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{bipartite}
\concept{dyad-independent}
\concept{frequently-used}
\concept{quantitative nodal attribute}
\concept{undirected}
