% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_chisq.R
\name{esc_chisq}
\alias{esc_chisq}
\title{Compute effect size from Chi-Square coefficient}
\usage{
esc_chisq(chisq, p, totaln, es.type = c("d", "g", "or", "logit", "r",
  "f", "eta", "cox.or", "cox.log"), study = NULL)
}
\arguments{
\item{chisq}{The chi-squared value. One of \code{chisq} or \code{p} must be reported.}

\item{p}{The p-value of the chi-squared or phi-value.}

\item{totaln}{A vector of total sample size(s).}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"f"}}{returns effect size Cohen's \code{f}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{convert_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{convert_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
  \item{\code{"eta"}}{returns effect size eta squared}
}}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size from Chi-Square coefficient
}
\note{
This effect size should only be used for data from 2x2 frequency
      tables. Furthermore, use this approximation for the effect size only,
      if information about the 2x2 frequencies or proportions are not available.
      Else, \code{\link{esc_2x2}} or \code{\link{esc_bin_prop}} provide better
      estimates for the effect size.
}
\examples{
# Effect size based on chi-squared value
esc_chisq(chisq = 9.9, totaln = 100)

# Effect size based on p-value of chi-squared
esc_chisq(p = .04, totaln = 100)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}
