% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ppsd.R
\name{plot_ppsd}
\alias{plot_ppsd}
\title{Plot a probabilistic power spectral density estimate (PPSD)}
\usage{
plot_ppsd(data, res = c(500, 500), n, ...)
}
\arguments{
\item{data}{\code{List} object, spectrogram to be plotted. Must be output
of \code{signal_spectrogram()} or of equivalent structure.}

\item{res}{\code{Integer} vector of length two, factors of image 
resolution in pixels, i.e. in time and frequency dimension.  
Default is \code{c(100, 100)}.}

\item{n}{\code{Integer} vector of length two, factors by which the image 
will be smoothend by a running average. \code{n} sets the filter window 
size, in x and y direction, respectively. By default, the window sizes 
are set to one percent of the input data set dimension.}

\item{\dots}{Additional arguments passed to the plot function.}
}
\value{
Graphic output of a spectrogram.
}
\description{
The function uses the output of \code{signal_spectrogram()} to plot a 
probabilistic power spectral density estimate.
}
\examples{

## load example data set
data(rockfall)

## deconvolve data set
r <- signal_deconvolve(data = rockfall_eseis)

## calculate PSD
p <- signal_spectrogram(data = r)

## plot PPSD
plot_ppsd(data = p$PSD)

## plot PPSD with lower resolution, more smoothing and other colour
ppsd_color <- colorRampPalette(c("white", "black", "red"))

plot_ppsd(data = p$PSD, 
          res = c(200, 200), 
          n = c(15, 20), 
          col = ppsd_color(200))

}
\seealso{
\code{\link{signal_spectrogram}}
}
\author{
Michael Dietze
}
\keyword{eseis}
