% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_from_bin.R
\name{struct.from.bin}
\alias{struct.from.bin}
\title{Creation of struct class object from a binary volume}
\usage{
struct.from.bin(
  vol,
  roi.name = vol$description,
  roi.nb = 1,
  roi.color = "#379DA2",
  external.only = FALSE,
  alias = "",
  description = paste("RoI from", vol$object.alias)
)
}
\arguments{
\item{vol}{"volume" class object, of binary modality.}

\item{roi.name}{Character string, representing the name of created RoI.}

\item{roi.nb}{Positive integer, representing the number of created RoI.}

\item{roi.color}{Color of the created RoI, in hex code format ("#RRGGBB").}

\item{external.only}{Boolean. If \code{TRUE}, only external contours are kept.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object.}
}
\value{
Returns a "struct" class object (see \link[espadon]{espadon.class}
for class definition), including the unique \code{roi.name} as region of interest.
}
\description{
The \code{struct.from.bin} function creates a struct object with
a unique RoI, defined by the contours of binary volume.
}
\examples{
# Contours of a sphere of 10 mm radius
b.sphere <- vol.create (n.ijk = c (40, 40, 40), dxyz = c(1,1,1), 
                        mid.pt = c (0, 0, 0), modality = "binary", 
                        default.value = FALSE)
xyz <- expand.grid (-20:19, -20:19, -20:19)
R <- 10
Sphere.flag <- (xyz[, 1]^2 + xyz[, 2]^2 + xyz[, 3]^2) <= R^2
b.sphere$vol3D.data[Sphere.flag] <- TRUE
b.sphere$max.pixel <- TRUE
S.sphere <- struct.from.bin (b.sphere, roi.name = "sphere", external.only = TRUE)
str (S.sphere$roi.info)                 
}
