% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_kplane.R
\name{display.kplane}
\alias{display.kplane}
\title{Display of a plane of a volume}
\usage{
display.kplane(
  vol,
  k = vol$k.idx[ceiling(length(vol$k.idx)/2)],
  pt00 = c(0, 0),
  dxy = c(1, 1),
  col = grey.colors(255, start = 0, end = 1),
  breaks = NULL,
  sat.transp = FALSE,
  add = FALSE,
  main = NULL,
  abs.lab = "i",
  ord.lab = "j",
  abs.flip = FALSE,
  ord.flip = FALSE,
  bg = "#000000",
  abs.rng = NULL,
  ord.rng = NULL,
  interpolate = FALSE
)
}
\arguments{
\item{vol}{"volume" class object to display. See \link[espadon]{espadon.class}
for class definitions.}

\item{k}{Number of the plane to display. By default \code{k} is located at
mid-plane of the volume.}

\item{pt00}{Origin point of the displayed plane. By default \code{pt00 = c (0, 0)},
corresponding to the bottom left of the displayed non-flipped image.}

\item{dxy}{width and height of a pixel in the plane. If \code{dxy = c (1, 1)}
(default) abcissa and ordinate correspond to pixel number in the plane.}

\item{col}{Vector, representing the color palette of the image.}

\item{breaks}{One of :
\itemize{
\item \code{NULL} : the minimum and the maximum value of the \code{vol} define
the range.
\item Vector giving the breakpoints of each color. Outside values are transparent,
leaving the background visible, depending on \code{sat.transp}.
}}

\item{sat.transp}{Boolean. If \code{TRUE}, outside values are transparent, else
set to \code{breaks} limits colors.}

\item{add}{Boolean indicating whether to display the background image.}

\item{main}{Title of the background image. If \code{main = NULL},
the title just indicates the value of \code{k}.}

\item{abs.lab}{Label of the image abcissa. By default \code{abs.lab = 'i'}.}

\item{ord.lab}{Label of the image ordinate. By default \code{ord.lab = 'j'}.}

\item{abs.flip}{Boolean defaults to \code{FALSE} flipping the horizontal axis
of the background image.}

\item{ord.flip}{Boolean defaults to \code{FALSE} flipping the vertical axis
of the background image.}

\item{bg}{Background color of the image. By default, this color is black.}

\item{abs.rng}{Vector of 2 elements indicating the minimum and maximum
background image abscissa to display.}

\item{ord.rng}{Vector of 2 elements indicating the minimum and maximum
background image ordinate to display.}

\item{interpolate}{Boolean, indicating whether to apply linear interpolation
to the image.}
}
\value{
Returns a display of the  \mjeqn{k^{th}}{ascii} image plane of \code{vol}.
}
\description{
The \code{display.kplane} function displays the requested plane
of a "volume" class object. This function is low-level, used for example
in the function \link[espadon]{display.plane} with more intuitive arguments.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for
# better result)
step <- 5
patient <- toy.load.patient (modality = c("ct","mr", "rtdose"),
                             dxyz = rep (step, 3), beam.nb = 3)
MR <- patient$mr[[1]]
CT <- patient$ct[[1]]
D <- patient$rtdose[[1]]

# display

display.kplane (CT)

display.kplane (MR, k = floor (length(MR$k.idx)*5/8), 
                col = grey.colors (256, start = 0, end = 1),
                breaks = seq (0, 500, length.out = 257), bg = "darkblue")


display.kplane (D, k = floor (length(D$k.idx)*3/8),
                col = rainbow (256, s = seq (1, 0, length.out = 256),
                               start = 0, end = 4/6,
                               alpha = seq (0.8, 0, length.out=256),
                               rev = TRUE),
                bg = "darkblue", ord.flip = TRUE, sat.transp = FALSE,
                interpolate = FALSE)

display.kplane (CT, k = floor (length(CT$k.idx)/3), col = pal.RVV (1000),
                breaks = seq(-1000, 1000, length.out = 1001),
                bg = "darkblue", ord.flip = TRUE, interpolate = FALSE)
}
\seealso{
\link[espadon]{display.plane}.
}
