% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_shape.R
\name{bin.cuboid}
\alias{bin.cuboid}
\alias{bin.cylinder}
\alias{bin.ellipsoid}
\title{Create a volume containing predefined shapes}
\usage{
bin.cuboid(
  back.vol,
  pt.min,
  pt.max,
  ref.shape = back.vol$ref.pseudo,
  T.MAT = NULL,
  modality = "weight",
  alias = "",
  description = NULL
)

bin.cylinder(
  back.vol,
  center,
  radius,
  height,
  ref.shape = back.vol$ref.pseudo,
  T.MAT = NULL,
  modality = "weight",
  alias = "",
  description = NULL
)

bin.ellipsoid(
  back.vol,
  center,
  radius,
  ref.shape = back.vol$ref.pseudo,
  T.MAT = NULL,
  modality = "weight",
  alias = "",
  description = NULL,
  ...
)
}
\arguments{
\item{back.vol}{"volume" class object.}

\item{pt.min, pt.max}{Minimum and maximum x, y, z coordinates of the vertices
of the rectangular cuboid.}

\item{ref.shape}{Character string. Pseudonym of the frame of reference in which
the requested shape is defined.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm}
or \link[espadon]{load.T.MAT}. If\code{T.MAT = NULL}, \code{ref.shape} must be
equal to \code{back.vol$ref.pseudo}.}

\item{modality}{modality ("binary" or "weight") of the generated object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object.}

\item{center}{Numeric vector of length 3, representing the xyz-center of the
cylinder or the ellipsoid.}

\item{radius}{Positive number, or xy-vector or xyz-vector of 2 or 3 positive
numbers, representing the radius of the cylinder or the ellipsoid.}

\item{height}{Positive number representing the height of the cylinder.}

\item{...}{Additional arguments, such as \code{error}, representing the relative
error on the volume of the ellipsoid, if \code{back.vol$orientation = c(1, 0, 0, 0, 1, 0)}.}
}
\value{
Returns a "volume" class object of "binary" or "weight" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{back.vol}.
\itemize{
\item In the “binary” modality, voxels with 50 percent of their volume within
the requested shape are set to \code{TRUE}.
\item In the “weight” modality, the value of each voxel is its volume fraction
included in the requested shape.
}
}
\description{
These functions create espadon objects of class “volume”, and
of modality “binary” or “weight”, by selecting the voxels defining a rectangular
cuboid, an elliptical cylinder or an ellipsoid.
}
\examples{
# Creation of back.vol
CT <- vol.create (c(80, 80,40), c(1.2, 1.2, 2), 
                  pt000 = c(-50.4,-50.4,-75), modality = "ct", 
                  default.value = as.integer(-997), value.sd = 1)
                   
# Creation of a cuboid
cuboid <- bin.cuboid(CT, pt.min = c(-45.3, -40.2, -60.4), 
                     pt.max =  c(-15.6, -20.2, -40.2))
                       
# Definition of the shape frame of reference
angle.yz =30
Myz <- cbind(c(1, 0, 0, 0),
             c(0, cos(pi * angle.yz / 180), sin(pi * angle.yz / 180), 0) ,
             c(0, -sin(pi * angle.yz / 180), cos(pi * angle.yz / 180), 0),
             c(0, 0, 0, 1 )) 
angle.xy <- 59
Mxy <- cbind(c(cos(pi * angle.xy / 180), sin(pi * angle.xy / 180), 0, 0) ,
             c(-sin(pi * angle.xy / 180), cos(pi * angle.xy / 180), 0, 0), 
             c(0 ,0, 1, 0), c(0, 0, 0, 1)) 

t.mat <- ref.srctodest.add("ref1", "shaperef", TM = Myz \%*\% Mxy) 

# Creation of a cylinder 
cylinder <- bin.cylinder(CT, center = c(10.3, 30.6, -30.7), 
                         radius =  c(10, 20), height = 50, 
                         ref.shape ="shaperef", T.MAT = t.mat) 
                      
# Creation of an ellipsoid 
ellipsoid <- bin.ellipsoid(CT, center = c(-20.1, 0.1, -15), 
                           radius =  c(19.3, 20.2, 15.3))  
                       
 # Display                         
 k.idx <- unique(which(cuboid$vol3D.data>0, arr.ind = TRUE)[,3]) - 1
 display.3D.stack(cuboid, k.idx, border = FALSE,
                  col = c("#FFFFFF00", "#EBDFDFFF", "#D8BFBFFF", "#C59F9FFF", 
                          "#B27F7FFF", "#9F5F5FFF", "#8C3F3FFF", "#791F1FFF", 
                          "#660000FF"))   
                           
 k.idx <- unique(which(cylinder$vol3D.data>0, arr.ind = TRUE)[,3]) - 1
 display.3D.stack(cylinder, k.idx, border = FALSE,
                  col = c("#FFFFFF00", "#DFEBDFFF", "#BFD8BFFF", "#9FC59FFF", 
                          "#7FB27FFF", "#5F9F5FFF", "#3F8C3FFF", "#1F791FFF", 
                          "#006600FF"))    

 k.idx <- unique(which(ellipsoid$vol3D.data>0, arr.ind = TRUE)[,3]) - 1
 display.3D.stack(ellipsoid, k.idx, border = FALSE,
                  col = c("#FFFFFF00", "#DFDFEBFF", "#BFBFD8FF", "#9F9FC5FF", 
                          "#7F7FB2FF", "#5F5F9FFF", "#3F3F8CFF", "#1F1F79FF", 
                          "#000066FF"))                           
}
\seealso{
\link[espadon]{add.shape}
}
